﻿uses MathExtensions;

// условие задачи:
function Uslovie(c, f: int): bool; 
begin
   // c - сантимы, f - франки
   var c1 := f;        // после обмена: сантимов стало f
   var f1 := c div 5;  // после обмена: франков стало c/5 (должно быть целым)
   Result := 100 * f + c = 5 * (100 * f1 + c1)
end;

// РЕШАЕМ ЗАДАЧУ
procedure Solve();
begin  
   // f - франки (0-99), c - сантимы (0-99, кратно 5)
   foreach var f in Range(0, 100) do   
      foreach var c in Range(0, 100, 5) do 
          if Uslovie(c, f) then begin
              // печатаем ответ:
              Writeln($' Франков было:  {f}  | Франков было:  {c}');
              // После обмена:
              var f1 := c div 5;
              var c1 := f;
              Writeln($' Франков стало: {f1}  | Франков стало: {c1}');    
           end;
    Writeln;              
end; 


procedure Solve2();
begin    
   var francs := Range(0, 100);   
   var centims := Range(0, 100, 5);
   var solutions := Cartesian(centims, francs)
                   .Where(\(c, f) -> Uslovie(c, f))  
                   .Select(\(c, f) -> (c, f));     
   // печатаем ответ:                   
  foreach var (c, f) in solutions do begin
     Writeln($' Франков было:  {f}  | Франков было:  {c}');
     var f1 := c div 5;
     var c1 := f;
     Writeln($' Франков стало: {f1}  | Франков стало: {c1}');    
   end;
   Writeln;      
end; 

     
procedure Solve3();
begin   
   for var f := 0 to 99 do
      for var c := 0 to 99 do begin
         var c1 := f;
         var f1 := c div 5;
         if (100 * f + c = 5 * (100 * f1 + c1)) then begin
             Writeln($' Франков было:  {f}  | Франков было:  {c}');
             Writeln($' Франков стало: {f1}  | Франков стало: {c1}');  
             var zaplatil := 4 * (100 * f1 + c1);
             Writeln($' Мсье Метивье заплатил: {zaplatil div 100} фр. и {(zaplatil - zaplatil div 100 * 100)} c.');
            Writeln;
         end
      end;
   Writeln;
end;     
     
     
begin
   Writeln(' Чисто французская задача');
   Writeln(' Задача Д44 из книги Математический фольклор');   
   Writeln; 
   Solve();   
   Solve2(); 
   Solve3();    
end.
